;*********************************
;* Jungle Jag - JagCode 500 Game *
;*********************************
;
; by Cedric Bourse, (a.k.a Orion_) [2007]
;
; http://onorisoft.info/
;
; This Source Code is licensed under the term of the following Creative Commons License:
; http://creativecommons.org/licenses/by-nc/3.0/
;
; You are free:
;  * to Share : to copy, distribute and transmit the work
;  * to Remix : to adapt the work
;
; Under the following conditions:
;  * Attribution. You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).
;  * Noncommercial. You may not use this work for commercial purposes.
;  * For any reuse or distribution, you must make clear to others the license terms of this work. The best way to do this is with a link to this web page.
;  * Any of the above conditions can be waived if you get permission from the copyright holder.
;  * Nothing in this license impairs or restricts the author's moral rights.
;

	.text

;---

InitMenu:
	move.w	#256,fade_cnt

	bsr	InitTextScreen
	lea	menutextB,a0
	bsr	RenderBigText
	lea	menutextS,a0
	bsr	RenderSmallTextGroup
	rts

;---

InitCredits:
	move.w	#256,fade_cnt

	bsr	InitTextScreen
	lea	creditstextB,a0
	bsr	RenderBigText
	lea	creditstextS,a0
	bsr	RenderSmallTextGroup

	lea	SFX_Credits,a0
	lea	SFX_CreditsE,a1
	bsr	AddSound

	rts

;---

Menu:

;----------------
; Screen Adjust

	move.w	#$810e,JOYSTICK
	move.l	JOYSTICK,d7

	btst.l	#1,d7			; Test A Button
	bne.s	.nA

	btst.l	#27,d7
	bne.s	.nxp
	addq.w	#1,XRELATIF

.nxp:	btst.l	#26,d7
	bne.s	.nxm
	subq.w	#1,XRELATIF

.nxm:	btst.l	#25,d7
	bne.s	.nyp
	addq.w	#1,YRELATIF

.nyp:	btst.l	#24,d7
	bne.s	.mofspr
	tst.w	YRELATIF
	beq.s	.mofspr			; don't go up if Y=0 (else OP bug not corrected in this sprite manager)
	subq.w	#1,YRELATIF

.mofspr:
	moveq	#0,d0			; Update new position
	moveq	#0,d1
	moveq	#0,d2
	bsr	SetSpriteXY
	moveq	#1,d0			; Update new position
	moveq	#0,d1
	moveq	#8,d2
	bsr	SetSpriteXY
.nA:

;----------------

	move.w	#$810d,JOYSTICK		; Read Pad 1, B button
	move.l	JOYSTICK,d7		; Get B Button 0 = pressed, 1 = not pressed
	btst.l	#1,d7			; B Button (start game)
	bne.s	.eC
	addq.w	#1,phase
	move.w	#256,fade_cnt
	bra.s	.eval

.eC:
	move.w	#$810b,JOYSTICK		; Read Pad 1, C button
	move.l	JOYSTICK,d7		; Get C Button 0 = pressed, 1 = not pressed
	btst.l	#1,d7			; C Button (credits)
	bne.s	.em
	move.w	#11,phase
	move.w	#256,fade_cnt

.eval:
	lea	SFX_Valid,a0
	lea	SFX_ValidE,a1
	bsr	AddSound
.em:
	rts

;---

RenderBigText:	; a0 = text struct
	lea	LevelBuffer,a1
	lea	font,a2
	moveq	#0,d0
	move.w	(a0)+,d0	; Get X
	move.w	(a0)+,d1	; Get Y
	mulu	#320,d1
	add.l	d0,d1
	add.l	d1,a1
.retext:
	moveq	#0,d2
	move.b	(a0)+,d2
	bne.s	.rtxt
	rts
.rtxt:	lea	32(a1),a4
	cmpi.b	#' ',d2
	beq.s	.n
	subi.b	#'A',d2
	swap	d2
	lsr.l	#6,d2		; d2 * 1024 = 32*32
	lea	0(a2,d2.l),a3
	moveq	#32-1,d3
.renderletter:
	REPT	8
	move.l	(a3)+,(a1)+
	ENDR
	lea	320-32(a1),a1
	dbra	d3,.renderletter
.n:	move.l	a4,a1		; next letter
	bra.s	.retext

;---

RenderSmallText:	; a0 = text struct
	lea	LevelBuffer,a1
	lea	font2,a2
	moveq	#0,d0
	move.w	(a0)+,d0	; Get X
	move.w	(a0)+,d1	; Get Y
	mulu	#320,d1
	add.l	d0,d1
	add.l	d1,a1
.retext:
	moveq	#0,d2
	move.b	(a0)+,d2
	bne.s	.rtxt
	rts
.rtxt:	lea	11(a1),a4
	cmpi.b	#' ',d2
	beq.s	.n
	subi.b	#'@',d2
	mulu	#11,d2
	lea	0(a2,d2.l),a3
	moveq	#8-1,d3
.renderletter:
	REPT	11
	move.b	(a3)+,(a1)+
	ENDR
	lea	320-11(a1),a1
	lea	297-11(a3),a3
	dbra	d3,.renderletter
.n:	move.l	a4,a1		; next letter
	bra.s	.retext

;---

RenderSmallTextGroup:	; a0 = text group struct
	tst.w	(a0)
	bge.s	.render
	rts
.render:
	bsr	RenderSmallText
	move.l	a0,d0
	addq.l	#1,d0		; WORD Align !
	andi.l	#-2,d0
	movea.l	d0,a0
	bra.s	RenderSmallTextGroup
;---

InitTextScreen:
	bsr	UnSetSpriteList

	; Clear screen using blitter
	move.l	#LevelBuffer,A1_BASE
	move.l	#0,A1_CLIP
	move.l	#WID320|PIXEL8|XADDPHR|PITCH1,A1_FLAGS
	move.l	#0,B_PATD	; color
	move.l	#0,B_PATD+4	; color 64bits
	move.l	#0,A1_PIXEL
	move.l	#$0001FEC0,A1_STEP	; Y = 1; X = -320
	move.w	#240,d2
	swap	d2
	move.w	#320,d2
	move.l	d2,B_COUNT
	move.l	#PATDSEL|UPDA1,B_CMD	; Go Blit !!

	bsr	InitSpriteList

	moveq	#0,d0
	move.w	#256,d1
	move.w	#320,d2
	move.w	#256,d3
	move.l	#MenuBack,d4
	bsr	AddSprite

	moveq	#0,d0
	moveq	#8,d1
	move.w	#320,d2
	move.w	#240,d3
	move.l	#LevelBuffer,d4
	bsr	AddSprite8

	bsr	EndSpriteList
	bsr	SetSpriteList

	rts
